/*****************************************************************
** Ȩ:   Ƽ޹˾
** ļ:I2C_Serve.c
** 汾V1.0
** :IAR Embedded Workbench Evaluation for MSP430 4.10A
** :Huanglongsong
** ѭI2CЭ鶨غ
** :200811
*****************************************************************/
#include "msp430afe253.h"
#include "I2C_Define.h"
/****************************************************************
** I2C_Start                                                       
** ܣѭI2CЭ鶨
** : huanglongsong
** : 2008.11
** ļ:
** ޸־
*****************************************************************/
void I2C_Start(void)
{
    DIR_OUT;
    SDA_1;
    I2C_Delay();
    SCL_1;
    I2C_Delay();
    SDA_0;
    I2C_Delay();
    SCL_0;
}//End I2C_Start
/*****************************************************************
** I2C_Stop                                                      
** ܣѭI2CЭ鶨ֹͣ
** : huanglongsong
** : 2008.11
** ļ:
** ޸־
*****************************************************************/
void I2C_Stop(void)
{
    DIR_OUT;
    SDA_0;
    I2C_Delay();
    SCL_1;
    I2C_Delay();
    SDA_1;
}//End I2C_Stop
/*****************************************************************
*** I2C_ReceiveACK                                                      
** ܣACK ź,һβ
** : huanglongsong
** : 2008.11
** ļ:
** ޸־
******************************************************************/
void I2C_Write_ACK( void )
{
    SDA_1;
    DIR_IN;
    SCL_1;
    I2C_Delay();
    while(SDA_IN );
    SCL_0;
    I2C_Delay();
    DIR_OUT;
    return;
}//End I2C_ReceiveACK
/****************************************************************
** I2C_Read_Ack                                                      
** ܣݺһACKź
** : huanglongsong
** : 2008.11
** ļ:
** ޸־
*****************************************************************/
void I2C_Read_Ack(void)
{
    DIR_OUT;
    SCL_0;
    SDA_0;
    I2C_Delay();
    SCL_1;
    I2C_Delay();
    SCL_0;
    SDA_1;
}//End I2C_Read_Ack
/*****************************************************************
*** I2C_Read_NoAck                                                     
** ܣݺNoACKź
** : huanglongsong
** : 2008.11
** ļ:
** ޸־:
******************************************************************/
void I2C_Read_NoAck( void )
{
    DIR_OUT;
    SCL_0;
    SDA_1;
    I2C_Delay();
    SCL_1;
    I2C_Delay();
    SCL_0;
}//End I2C_Read_Ack
/***************************************************************** 
** I2C_Receiveuchar                                                   
** ܣһֽڵ
** :huanglongsong 
** : 2008.11
** ļ:
** ޸־:
*****************************************************************/
uchar I2C_Receiveuchar(void)
{
    uchar Read_Data = 0x00;                            //ֵ
    uchar DataBit = 0x00;                              //ÿһclk ܵ
    
    SCL_0;
    I2C_Delay();
    SDA_1;
    DIR_IN;
    for( uchar i = 0;i < 8;i++ )
    {
        SCL_1;
        I2C_Delay();
        DataBit = SDA_IN;
        SCL_0;
        I2C_Delay();
        I2C_Delay();
        Read_Data = ( ( Read_Data << 1 ) | DataBit ); //δRead_Data
    }
    return( Read_Data );
}//End I2C_Receiveuchar
/*******************************************************************
** I2C_Senduchar                                                    
** ܣѭI2CЭ鶨巢һֽ
** : huanglongsong
** : 2008.11
** ļ:
** ޸־:
*******************************************************************/
void I2C_Senduchar( uchar Wr_Data )
{
    DIR_OUT;
    SCL_0;
    SDA_1;
    for( uchar i = 0;i < 8;i++ )
    {
        if( Wr_Data & 0x80 ) 
        {
            SDA_1;                            //λǷΪ1,Ϊ1SDA= 1
        }
        else 
        {
            SDA_0;                            // SDA=0
        }
        I2C_Delay();
        SCL_1;
        I2C_Delay();
        SCL_0;
        I2C_Delay();
        Wr_Data <<= 1;                        //һλ,һ  
    }
    SDA_1;
    return;
}//End I2C_Senduchar